# -*- coding: utf-8 -*-
from mysite.pywebsv.utils import SUCCESS_CODE, MESSAGE_CODE, interface_response, request_valid, online_employee, \
    stamp2datetime, datetime2stamp, SYSTEM_EXCEPTION, DATA_EXCEPTION, save_notification, \
    remove_history, user_photo, paging
from ladon.ladonizer import ladonize
from django.utils.translation import ugettext_lazy as _
import json


class BioTimeAppOverTime(object):

    """
    【Overtime】加班
    """

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def category(self, source, device_token, language, token):
        """
        加班类型
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
            {"code": 1, "error": "", "describe": "", "message": "", "data":[{"code": 编号, "name": "名字""}}
        """
        choices = [
            {'code': 1, 'name': u'{0}'.format(_(u'正常加班'))},
            {'code': 2, 'name': u'{0}'.format(_(u'周末加班'))},
            {'code': 3, 'name': u'{0}'.format(_(u'节假日加班'))},
        ]
        return interface_response(SUCCESS_CODE, json.dumps(choices), '', 'successful')

    @request_valid
    @ladonize(int, long, long, str, int, str, str, str, rtype=str)
    def apply(self, overtime_type, start, end, remark, source, device_token, language, token):
        """
        加班申请
        @param overtime_type: ·（必填）加班类型, 上传category获取的数据里面的code值（数据获取调用 BioTimeAppOverTime --> category）
        @param start:         ·（必填）加班开始时间
        @param end:           ·（必填）加班结束时间
        @param remark:        ·（选填）备注
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
        """
        from django.db.models import Q
        from mysite.att.att_utils import approve_flow
        from mysite.att.models.model_overtime import OverTime
        from mysite.att import constant
        start = stamp2datetime(start)
        end = stamp2datetime(end)
        if start >= end:
            describe = u'{0}'.format(_(u'结束时间不能小于开始时间'))
            message = u'{0}'.format(_(u'结束时间不能小于开始时间'))
            return interface_response(MESSAGE_CODE, '', '', describe, message)
        applier = online_employee()
        obj_tmp = OverTime.objects.filter(emp=applier, audit_status=constant.AUDIT_SUCCESS).exclude(Q(starttime__gt=end) | Q(endtime__lt=start))
        if obj_tmp:
            describe = u'{0}'.format(_(u'人员 %s 加班时间有重叠') % applier)
            message = u'{0}'.format(_(u'人员 %s 加班时间有重叠') % applier)
            return interface_response(MESSAGE_CODE, '', '', describe, message)
        try:
            obj = OverTime()
            obj.emp = applier
            obj.starttime = start
            obj.endtime = end
            obj.ottype = overtime_type
            obj.remark = u'{0}'.format(remark.decode('utf-8'))
            obj.approve_level = 1
            obj.save()
            obj, approve_level = approve_flow(constant.CATEGORY_OVERTIME, obj, applier, applier.PIN, '', None, None)
            obj.save()
            data = {
                'message': u'{0}'.format(_(u'Request already processing'))
            }
            return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(int, int, int, str, str, str, rtype=str)
    def my_application(self, approve_status, page_num, source, device_token, language, token):
        """
        获取自己的调班申请(申请,通过,拒绝)数据
        @param approve_status:  0:通过&拒绝, 1:申请, 2:通过，3：拒绝
        @param page_num:        页码（每页１５条数据）
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回结果
            请求成功
                {"code":1,"error":"","describe":"","message":"","data":{"category":1,"items":[{"code":对象ID,"pin":"工号","name":"姓名","photo":"照片地址","start":"请假开始时间","end":"请假结束时间","remark":"申请备注","category":"请假类型(标题)","apply_time":"申请时间","approve_status":"审批状态值(int)","approve_describe":"审批状态","approved_remark":"审批备注","approved_time":"审批时间"}, ]}}
            请求失败
                {"code":-10001,"error":"","describe":"","message":"弹窗信息","data":""}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att import constant
        from mysite.iclock.models.model_notification import CATEGORY_OVERTIME

        if approve_status in (0, 1, 2, 3):
            emp = online_employee()
            if not approve_status:
                _approve_status = ' audit_status in (%s, %s, %s) ' % (constant.AUDIT_SUCCESS, constant.REFUSE, constant.CANCEL_AUDIT_SUCCESS)
            elif approve_status in (constant.APPLICATION, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.APPLICATION, constant.AUDITING)
            elif approve_status in (constant.REFUSE, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.REFUSE, constant.CANCEL_AUDIT_SUCCESS)
            else:
                _approve_status = ' audit_status in (%s) ' % approve_status
            where = ' u.userid = %(applier)s and %(audit_status)s  ' % ({'applier': emp.pk, 'audit_status': _approve_status})
            sort_name = 'change_time'
            if approve_status in (1, ): #Apply
                sort_name = 'create_time'
            page_num = page_num or 1
            try:
                sql = get_sql('sql', sqlid='overtime_application', app="pywebsv", params={'where': where})
                sql = paging(sql, page_num, sort_name)
                rows = p_query(sql)
                data = {
                    'category': CATEGORY_OVERTIME,
                    'items': []
                }
                if rows:
                    status = dict(constant.ALL_STATUS)
                    types = dict(constant.OT_TYPE)
                    items = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                              'start': datetime2stamp(r[3]), 'end': datetime2stamp(r[4]),
                              'remark': r[5], 'category': u'{0}'.format(types.get(r[6], r[6])),
                              'apply_time': datetime2stamp(r[7]),
                              'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                              'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])} for r in rows]
                    data['items'] = items
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'parameter approve_status={0} error'.format(approve_status)
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, int, int, str, str, str, rtype=str)
    def approval_list(self, approve_status, page_num, order_by, source, device_token, language, token):
        """
        获取审批列表
        @param approve_status:  ·（必填）0:通过&拒绝, 1:申请, 2:通过，3：拒绝
        @param page_num:        页码（每页１５条数据）
        @param order_by:        排序(1: 申请时间，２：审批时间), 申请界面默认为１，审批界面默认为２
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
            {"code": 1, "error": "", "describe": "", "message": "", "data":[{"id": 对象ID, "pin": "工号", "name":"姓名", "photo":"照片地址", "start": "加班开始时间", "end": "加班结束时间", "remark":"申请备注", "approve_status": "审批状态"},]}
        """
        from mysite.sql_utils import get_sql, p_query
        from mysite.att import constant
        if approve_status in (0, 1, 2, 3):
            emp = online_employee()
            if not approve_status:
                _approve_status = ' audit_status in (2, 3) '
            elif approve_status in (constant.APPLICATION, ):
                _approve_status = ' audit_status in (%s, %s) ' % (constant.APPLICATION, constant.AUDITING)
            else:
                _approve_status = ' audit_status in (%s) ' % approve_status
            where = ' pdr.approver_id = %(approver)s and %(audit_status)s  ' % ({'approver': emp.pk, 'audit_status': _approve_status})
            print "[*]Where:", where
            sort_name = 'change_time'
            if approve_status in (1, ): #Apply
                sort_name = 'create_time'
            page_num = page_num or 1
            try:
                sql = get_sql('sql', sqlid='overtime_application', app="pywebsv", params={'where': where})
                sql = paging(sql, page_num, sort_name)
                rows = p_query(sql)
                data = []
                if rows:
                    status = dict(constant.ALL_STATUS)
                    types = dict(constant.OT_TYPE)
                    data = [{'code': r[0], 'pin': r[1], 'name': r[2], 'photo': user_photo(r[1]),
                             'start': datetime2stamp(r[3]), 'end': datetime2stamp(r[4]),
                             'remark': r[5], 'category': u'{0}'.format(types.get(r[6], r[6])),
                             'apply_time': datetime2stamp(r[7]),
                             'approve_status': r[8], 'approve_describe': u'{0}'.format(status.get(r[8], r[8])),
                             'approved_remark':r[10], 'approved_time': datetime2stamp(r[11])
                             } for r in rows]
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            except Exception, e:
                import traceback
                traceback.print_exc()
                return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
        else:
            describe = 'Approve status not in (0,1,2,3)'
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, str, int, str, str, str, rtype=str)
    def approve(self, code, approve_status, remark, source, device_token, language, token):
        """
        加班审批
        @param code:                对象ID
        @param approve_status:      ·（必填）审批状态(2:通过/3:拒绝)
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype:
        """
        from mysite.att.models.model_overtime import OverTime
        from mysite.att import constant
        from mysite.att.att_utils import approve_flow, save_history
        if code:
            if approve_status not in (constant.AUDIT_SUCCESS, constant.REFUSE):
                describe = 'param approve_status out of range'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
            approver = online_employee()
            objs = OverTime.objects.filter(id=code)
            if objs:
                try:
                    obj = objs[0]
                    applier = obj.emp
                    level = obj.approve_level
                    obj.audit_reason = u'{0}'.format(remark.decode('utf-8'))
                    obj.audit_user_id = approver.pk
                    approver_name = approver.EName or approver.PIN
                    obj, approve_level = approve_flow(constant.CATEGORY_OVERTIME, obj, applier, applier.PIN, '', approver_name, approve_status)
                    obj.save()
                    approver = approver.PIN
                    save_history(constant.CATEGORY_OVERTIME, obj.pk, level, approve_status, approver, approver_name, remark)
                    data = {
                        'message': u'{0}'.format(_(u'OK'))
                    }
                    return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
                except Exception, e:
                    print u"{0}".format(e)
                    # import traceback
                    # traceback.print_exc()
                    return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)
            else:
                describe = 'Object Not Found'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        else:
            describe = _(u'Object ID Not Found')
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)

    @request_valid
    @ladonize(int, int, str, str, str, rtype=str)
    def revoke(self, code, source, device_token, language, token):
        """
        @param code:                对象ID
        @param source:              数据来源(1: IOS， 2：Android)
        @param device_token:        消息推送Token
        @param language:
        @param token:
        @rtype:
        """
        from mysite.att.models.model_overtime import OverTime
        from mysite.att import constant
        from mysite.att.att_utils import approve_flow, save_history
        if code:
            approver = online_employee()
            objs = OverTime.objects.filter(id=code)
            if objs:
                obj = objs[0]
                applier = obj.emp
                if obj.audit_status not in (constant.AUDIT_SUCCESS, ):
                    message = _(u'Not allowed')
                    return interface_response(MESSAGE_CODE, '', '', '', message)
                obj.audit_status = constant.CANCEL_AUDIT_SUCCESS
                obj.audit_user_id = approver.pk
                obj.audit_reason = ''
                super(OverTime, obj).save()
                approve_level = obj.approve_level + 1
                approver_name = approver.EName or approver.PIN
                approver = approver.PIN
                obj, approve_level = approve_flow(constant.CATEGORY_OVERTIME, obj, applier, applier.PIN, '', approver_name, constant.CANCEL_AUDIT_SUCCESS)
                obj.save()
                save_history(constant.CATEGORY_OVERTIME, obj.pk, approve_level, constant.CANCEL_AUDIT_SUCCESS, approver, approver_name, '')
                data = {
                    'message': u'{0}'.format(_(u'OK'))
                }
                return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')
            else:
                describe = 'Object Not Found'
                return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)
        else:
            describe = 'Parameter instance Not Found'
            return interface_response(MESSAGE_CODE, '', '', describe, DATA_EXCEPTION)